/*
 * eeprom.c
 *
 *  Created on: Mar 31, 2015
 *      Author: Jordan
 */

#include "spi.h"
#include "stdlib.h"

// SPI transfer settings
spiDAT1_t spi_eeprom = {TRUE, FALSE, SPI_FMT_0, SPI_CS_1};

uint8 eeprom_status(){
	// Get status
	uint16 tx[2] = {0x5,0};
	uint16 rx[2];
	spiTransmitAndReceiveData(spiREG1, &spi_eeprom, 2, tx, rx);

	// Return status
	return rx[1];
}

void eeprom_write(uint16 address, uint8 data){
	// Unlock eeprom
	uint16 tx = 0x6;
	spiTransmitData(spiREG1, &spi_eeprom, 1, &tx);

	// Write data
	uint16 tx2[4] = {0x2, address>>8, address&0xFF, data};
	spiTransmitData(spiREG1, &spi_eeprom, 4, tx2);

	// Wait until writing is done
	uint16 status;
	do {
		status = eeprom_status();
	} while(status & 0x1 == 0x1);

	// Lock eeprom
	tx = 0x4;
	spiTransmitData(spiREG1, &spi_eeprom, 1, &tx);
}

void eeprom_write_array(uint16 address, uint32 n, uint8* data){
	// Unlock eeprom
	uint16 tx = 0x6;
	spiTransmitData(spiREG1, &spi_eeprom, 1, &tx);

	// Write data
	uint16* tx2 = (uint16*) malloc(2*(n+3));
	uint16 i;
	for(i=0;i<n;i++){
		tx2[i+3] = data[i];
	}
	tx2[0] = 0x2;
	tx2[1] = address>>8;
	tx2[2] = address&0xFF;
	spiTransmitData(spiREG1, &spi_eeprom, n+3, tx2);

	// Wait until writing is done
	uint16 status;
	do {
		status = eeprom_status();
	} while(status & 0x1 == 0x1);

	// Lock eeprom
	tx = 0x4;
	spiTransmitData(spiREG1, &spi_eeprom, 1, &tx);

	// Free memory
	free(tx2);
}

uint8 eeprom_read(uint16 address){
	// Get data
	uint16 tx[4] = {0x3, address>>8, address&0xFF, 0x0};
	uint16 rx[4];
	spiTransmitAndReceiveData(spiREG1, &spi_eeprom, 4, tx, rx);

	// Return data
	return rx[3];
}

void eeprom_read_array(uint16 address, uint32 n, uint8* dest){
	// Get data
	uint16* tx = (uint16*) malloc(2*(n+3));
	uint16* rx = (uint16*) malloc(2*(n+3));
	tx[0] = 0x3;
	tx[1] = address>>8;
	tx[2] = address&0xFF;
	spiTransmitAndReceiveData(spiREG1, &spi_eeprom, n+3, tx, rx);

	// Return data
	uint16 i;
	for(i=0;i<n;i++){
		dest[i] = rx[i+3];
	}

	// Free memory
	free(tx);
	free(rx);
}
